@echo off

rem SAMPLE script for creating a signed CAB file.
rem Requires some "packsign" utilities from Microsoft.

echo Retrieving current mng4ie.dll release build
del mng4ie.dll
del mng4ie.cab
del mng4ie.pvk
del mng4ie.spc
del mng4ie.cer
copy ..\releasemindependency\mng4ie.dll

echo Generating test certificate and private key - press None button
..\..\packsign\makecert -sv mng4ie.pvk -n "CN=Your Name Here" mng4ie.cer

echo Packaging certificate in SPC file
..\..\packsign\cert2spc mng4ie.cer mng4ie.spc

rem echo Signing OCX/DLL (optional)
rem ..\..\packsign\signcode -spc mng4ie.spc -v mng4ie.pvk mng4ie.dll
rem echo Testing signature on OCX/DLL
rem ..\..\packsign\chktrust mng4ie.dll

echo Creating CAB
..\..\packsign\cabarc -s 6144 n mng4ie.cab mng4ie.dll mng4ie.inf

echo Signing CAB
rem Use this to create without timestamping:
rem ..\..\packsign\signcode -spc mng4ie.spc -v mng4ie.pvk mng4ie.cab
rem Or use this to inlude a timestamp (recommended):
..\..\packsign\signcode -spc mng4ie.spc -v mng4ie.pvk -t http://timestamp.verisign.com/scripts/timstamp.dll mng4ie.cab

echo Testing signature on CAB (optional) (this is only a test)
..\..\packsign\chktrust mng4ie.cab
