// mng4iectl.h
// Part of MNG4IE.
// Copyright 2002 by Jason Summers

#ifndef __MNG4IECTL_H_
#define __MNG4IECTL_H_

#include "resource.h"
#include <atlctl.h>

#define MNG4IEVERS      "1.0.4"
#define MNG4IEVERS_INT   1000401

#define MNG4IE_CALLBACK MNG_DECL

struct globals_struct {
	HINSTANCE hInst;
	HINSTANCE hInstResource;
	HCURSOR hcurHandIE;
	HFONT hfontMsg;
};


/////////////////////////////////////////////////////////////////////////////
// Cmng4iectl
class ATL_NO_VTABLE Cmng4iectl : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<Imng4iectl, &IID_Imng4iectl, &LIBID_MNG4IELib>,

	public CComControl<Cmng4iectl>,
	public IPersistStreamInitImpl<Cmng4iectl>,
	public IOleControlImpl<Cmng4iectl>,
	public IOleObjectImpl<Cmng4iectl>,
	public IOleInPlaceActiveObjectImpl<Cmng4iectl>,
	public IViewObjectExImpl<Cmng4iectl>,
	public IOleInPlaceObjectWindowlessImpl<Cmng4iectl>,
	public IPersistStorageImpl<Cmng4iectl>,
	public ISpecifyPropertyPagesImpl<Cmng4iectl>,
	public IQuickActivateImpl<Cmng4iectl>,
	public IDataObjectImpl<Cmng4iectl>,
	public IProvideClassInfo2Impl<&CLSID_mng4iectl, NULL, &LIBID_MNG4IELib>,
	public CComCoClass<Cmng4iectl, &CLSID_mng4iectl>,

	public IPersistPropertyBagImpl<Cmng4iectl>,
	public IObjectSafety
{
public:
	Cmng4iectl();
	~Cmng4iectl();


DECLARE_REGISTRY_RESOURCEID(IDR_MNG4IECTL)
DECLARE_NOT_AGGREGATABLE(Cmng4iectl)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(Cmng4iectl)
	COM_INTERFACE_ENTRY(Imng4iectl)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)

	COM_INTERFACE_ENTRY(IPersistPropertyBag)
	COM_INTERFACE_ENTRY(IObjectSafety)
END_COM_MAP()

BEGIN_PROP_MAP(Cmng4iectl)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_MSG_MAP(Cmng4iectl)
	CHAIN_MSG_MAP(CComControl<Cmng4iectl>)
	DEFAULT_REFLECTION_HANDLER()
	MESSAGE_HANDLER(WM_CREATE, OnCreate)
	MESSAGE_HANDLER(WM_CONTEXTMENU, OnContextMenu)
	MESSAGE_HANDLER(WM_SIZE, OnSize)
	MESSAGE_HANDLER(WM_DESTROY, OnDestroy)
	MESSAGE_HANDLER(WM_TIMER, OnTimer)
	MESSAGE_HANDLER(WM_ERASEBKGND, OnEraseBkgnd);
	MESSAGE_HANDLER(WM_LBUTTONDOWN, OnLButtonDown)
	MESSAGE_HANDLER(WM_SETCURSOR, OnSetCursor)
	MESSAGE_HANDLER(WM_HSCROLL, OnHScroll)
	MESSAGE_HANDLER(WM_VSCROLL, OnVScroll)
	MESSAGE_HANDLER(WM_MOUSEMOVE, OnMouseMove)
	MESSAGE_HANDLER(WM_LBUTTONUP, OnLButtonUP)
	MESSAGE_HANDLER(WM_LBUTTONDBLCLK, OnLButtonDblClk)
	MESSAGE_HANDLER(WM_MOUSEACTIVATE, OnMouseActivate)
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);


// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// Imng4iectl
public:
	STDMETHOD(get_Version)(/*[out, retval]*/ long *pVal);
	STDMETHOD(Animate)(/*[in]*/ long);

private:
	STDMETHOD(Load)(LPPROPERTYBAG pPropBag, LPERRORLOG pErrorLog);
	STDMETHOD(GetInterfaceSafetyOptions)(REFIID riid,DWORD *pdwSupportedOptions,DWORD *pdwEnabledOptions);
	STDMETHOD(SetInterfaceSafetyOptions)(REFIID riid,DWORD dwOptionsSetMask,DWORD dwEnabledOptions);
	STDMETHOD(DownloadURL)(BSTR strURL);

	static BOOL CALLBACK DlgProcProp(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
	static BOOL CALLBACK DlgProcAbout(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);

private:
	HRESULT OnDraw(ATL_DRAWINFO& di);
	void OnData(COurBindStatusCallback<Cmng4iectl>* pbsc, DWORD grfBSCF, BYTE* pBytes, DWORD dwSize);

	int ReadParamString(LPPROPERTYBAG pPropBag, LPERRORLOG pErrorLog, WCHAR *name, TCHAR *buf, int bufsize);

	void warn(TCHAR *fmt, ...);
	void set_error(TCHAR *fmt, ...);

	void find_window_size(void);
	void set_scrollbars(void);
	void scrollmsg(UINT msg,int code, short int pos);


	static mng_ptr MNG4IE_CALLBACK memallocfunc(mng_size_t n);
	static void MNG4IE_CALLBACK memfreefunc(mng_ptr p, mng_size_t n);
	static mng_bool MNG4IE_CALLBACK callback_openstream (mng_handle mng);
	static mng_bool MNG4IE_CALLBACK callback_closestream (mng_handle mng);
	static mng_bool MNG4IE_CALLBACK callback_readdata (mng_handle mng,mng_ptr pBuf,
                      mng_uint32 Buflen,mng_uint32 *pRead);
	static mng_bool MNG4IE_CALLBACK callback_processheader(mng_handle mng,mng_uint32 iWidth,mng_uint32 iHeight);
	static mng_ptr MNG4IE_CALLBACK callback_getcanvasline (mng_handle mng, mng_uint32 iLinenr);
	static mng_bool MNG4IE_CALLBACK callback_refresh (mng_handle mng, mng_uint32 iLeft, mng_uint32 iTop,
                       mng_uint32 iRight, mng_uint32 iBottom);
	static mng_uint32 MNG4IE_CALLBACK callback_gettickcount (mng_handle mng);
	static mng_bool MNG4IE_CALLBACK callback_settimer (mng_handle mng,mng_uint32 iMsecs);
	static mng_bool MNG4IE_CALLBACK callback_processtext(mng_handle mng,
       mng_uint8 iType, mng_pchar zKeyword, mng_pchar zText,
       mng_pchar zLanguage, mng_pchar zTranslation);
	static mng_bool MNG4IE_CALLBACK callback_traceproc (mng_handle mng,
	   mng_int32  iFuncnr,mng_int32  iFuncseq,mng_pchar  zFuncname);


	void handle_read_error(mng_retcode rv);
	int init_color_management(void);
	int my_init_mng(void);
	void SaveImage(void);
	void CopyToClipboard(void *mem,int size,UINT format);

	void AboutDialog(void);
	void PropDialog(void);
	void display_last_error(void);
	void DynamicMNG_FireEvent(mng_uint8 eventtype, POINTS pos);

	////////////////////////////////////////////
	////////////////////////////////////////////
	////////////////////////////////////////////

	HWND m_fhWnd;  // currently just a copy of m_hWnd
	int m_fullscreen;
	mng_handle m_mng;

#define STATE_INIT        0
#define STATE_LOADING     1  // stream opened
#define STATE_VALIDFRAME  2  // at least one frame has been displayed
#define STATE_LOADED      3  // image loaded; stream closed

#define MAXLEN_TEXT   5000
#define MAXLEN_URL     300
#define MAXLEN_TARGET  100

	// I think I'm not doing this very well. Probably there really needs to be
	// two state variables, one for loading from the network, and one for
	// the libmng processing. (or use libmng's new getstate API?)
	int m_loadstate;

	int m_paintedyet;

	int m_scrolling;    // allow scrolling of the image?
	int m_xscrollpos, m_yscrollpos;
	int m_windowwidth, m_windowheight; // client size of current window

	int m_diblinesize;
	DWORD m_dibsize;
	DWORD m_filesize;
	DWORD m_libmngpos;  // count of bytes that have been sent to libmng
	DWORD m_byteswanted;   // libmng asked for this many more bytes (add to libmngpos)

	unsigned char *m_mngdata;    // stores the MNG file in memory
	DWORD m_bytesloaded;  // 
	DWORD m_bytesalloc;   // size of mngdata
	int m_needresume;   // if previous mng_readdisplay call returned NEEDMOREDATA

	char *m_textdata;

	int m_errorflag;    // set if an error occurs that prevents displaying the image
	TCHAR m_errormsg[256];

	unsigned char *m_lpdib;    // pointer to header section of dib
	unsigned char *m_lpdibbits;   // pointer to "bits" section of dib (follows the header)
	LPBITMAPINFOHEADER m_lpdibinfo;  // alias for lpdib
	int m_frozen;
	int m_timer_set;
	int m_timer2_set;
	int m_dynamicmng; // does the image support dynamic MNG? (0=no, 1=yes, -1=unknown)
	int m_mouse_over_mng;
	int m_mouse_captured;

	int m_force_bgcolor;
	unsigned int m_bg_r,m_bg_g,m_bg_b;  // background color

	TCHAR m_url[MAX_PATH];  // the url of the stream   fixme: use MAX_URL?

	int m_islink;
	HBRUSH m_bkgdbrush;
	TCHAR m_linkurl[MAXLEN_URL];
	TCHAR m_linktarget[MAXLEN_TARGET];
	////////////////////////////////////////////
	////////////////////////////////////////////
	////////////////////////////////////////////

	LRESULT OnCreate(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnContextMenu(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnSize(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnDestroy(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnTimer(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnEraseBkgnd(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnLButtonDown(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnSetCursor(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnHScroll(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnVScroll(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnMouseMove(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnLButtonUP(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnLButtonDblClk(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnMouseActivate(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
};

#endif //__MNG4IECTL_H_
