// mng4ie.cpp
// Part of MNG4IE.
// Copyright 2002 by Jason Summers


// Note: Proxy/Stub Information
//      To build a separate proxy/stub DLL, 
//      run nmake -f mng4ieps.mk in the project directory.

#include "stdafx.h"

#include "resource.h"
#include <initguid.h>
#include "mng4ie.h"

#include "mng4ie_i.c"
#include "bindstatuscallback.h"
#include "libmng.h"
#include "mng4iectl.h"

CComModule _Module;

struct globals_struct globals;

BEGIN_OBJECT_MAP(ObjectMap)
OBJECT_ENTRY(CLSID_mng4iectl, Cmng4iectl)
END_OBJECT_MAP()

static void mng4ie_initialize(void)
{
	globals.hInst = _Module.m_hInst;
	globals.hInstResource = _Module.m_hInstResource;

	// Use system default cursor if available.
#ifndef IDC_HAND
#define IDC_HAND MAKEINTRESOURCE(32649)
#endif
	globals.hcurHandIE = LoadCursor(NULL,IDC_HAND);
	if(!globals.hcurHandIE) {
		globals.hcurHandIE = LoadCursor(globals.hInst,_T("CURHAND_IE"));
	}

	globals.hfontMsg= CreateFont(-12,0,0,0,FW_DONTCARE,TRUE,0,0,ANSI_CHARSET,
		OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DRAFT_QUALITY,
		VARIABLE_PITCH|FF_SWISS,_T("Arial"));

}

static void mng4ie_shutdown(void)
{
	if(globals.hfontMsg) DeleteObject((HGDIOBJ)globals.hfontMsg);
}

/////////////////////////////////////////////////////////////////////////////
// DLL Entry Point

extern "C"
BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID /*lpReserved*/)
{
    if (dwReason == DLL_PROCESS_ATTACH)
    {
        _Module.Init(ObjectMap, hInstance, &LIBID_MNG4IELib);
		mng4ie_initialize();
        DisableThreadLibraryCalls(hInstance);
    }
    else if (dwReason == DLL_PROCESS_DETACH) {
		mng4ie_shutdown();
        _Module.Term();
	}
    return TRUE;    // ok
}

/////////////////////////////////////////////////////////////////////////////
// Used to determine whether the DLL can be unloaded by OLE

STDAPI DllCanUnloadNow(void)
{
    return (_Module.GetLockCount()==0) ? S_OK : S_FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// Returns a class factory to create an object of the requested type

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv)
{
    return _Module.GetClassObject(rclsid, riid, ppv);
}

/////////////////////////////////////////////////////////////////////////////
// DllRegisterServer - Adds entries to the system registry

STDAPI DllRegisterServer(void)
{
    // registers object, typelib and all interfaces in typelib
    return _Module.RegisterServer(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
// DllUnregisterServer - Removes entries from the system registry

STDAPI DllUnregisterServer(void)
{
    return _Module.UnregisterServer(TRUE);
}


